import fetchMock from 'fetch-mock';
import faker from 'faker';

import {
  buildLiveToVODStatusURL,
  ChannelResponse,
  LiveToVODResponse,
  VODResponse,
  parseVODResponse,
} from 'mweb/common/fetch/liveToVODStatus';
import { GQLBroadcastType } from 'mweb/common/fetch/vods';

export const CHANNEL = 'liveOrVOD';
export const CHANNEL_ID = '1';
export const STREAM_ID = '30';
export const DIFFERENT_STREAM_ID = '40';
export const WRONG_CHANNEL_STREAM_ID = '50';

const LTV_CHANNEL_DATA: ChannelResponse = {
  status: '',
  display_name: 'Live or VOD?',
  game: '',
  _id: CHANNEL_ID,
  name: CHANNEL,
  logo: '',
};

export const LTV_VOD_DATA: VODResponse = {
  title: 'This was cool',
  description: '',
  _id: 'v12345',
  game: null,
  broadcast_type: GQLBroadcastType.Archive,
  preview: '//preview.url',
  created_at: faker.date.past().toString(),
  recorded_at: faker.date.past().toString(),
  views: 0,
  length: 0,
  channel: {
    name: CHANNEL,
  },
};

export const PARSED_LTV_VOD = parseVODResponse(LTV_VOD_DATA);

export const ONLINE_CHANNEL_WITH_TARGET_STREAM: LiveToVODResponse = {
  channel: LTV_CHANNEL_DATA,
  stream: {
    viewers: 2,
    _id: STREAM_ID,
    channel: LTV_CHANNEL_DATA,
    preview: {
      template: '//something.like.this',
    },
  },
  videos: [LTV_VOD_DATA],
};

export const ONLINE_CHANNEL_DIFFERENT_STREAM_TARGET_VOD: LiveToVODResponse = {
  channel: LTV_CHANNEL_DATA,
  stream: {
    viewers: 2,
    _id: DIFFERENT_STREAM_ID,
    channel: LTV_CHANNEL_DATA,
    preview: {
      template: '//something.like.this',
    },
  },
  videos: [LTV_VOD_DATA],
};

export const OFFLINE_CHANNEL_TARGET_VOD: LiveToVODResponse = {
  channel: LTV_CHANNEL_DATA,
  stream: null,
  videos: [LTV_VOD_DATA],
};

export const OFFLINE_CHANNEL_WITHOUT_TARGET_VOD: LiveToVODResponse = {
  channel: LTV_CHANNEL_DATA,
  stream: null,
  videos: [],
};

export const VOD_EXISTS_BUT_STREAM_IS_FOR_DIFFERENT_CHANNEL: LiveToVODResponse = {
  channel: LTV_CHANNEL_DATA,
  stream: null,
  videos: [
    {
      title: 'Pirates coming for you',
      description: '',
      _id: 'v54321',
      game: null,
      broadcast_type: GQLBroadcastType.Archive,
      preview: '//preview.url',
      created_at: '0',
      recorded_at: '0',
      views: 0,
      length: 0,
      channel: {
        name: 'piratesahoy',
      },
    },
  ],
};

export function mockOnlineChannelWithTargetStream(): void {
  fetchMock.mock(buildLiveToVODStatusURL(CHANNEL_ID, STREAM_ID), {
    body: ONLINE_CHANNEL_WITH_TARGET_STREAM,
  });
}

export function mockOnlineChannelWithDifferentStreamWithTargetVOD(): void {
  fetchMock.mock(buildLiveToVODStatusURL(CHANNEL_ID, STREAM_ID), {
    body: ONLINE_CHANNEL_DIFFERENT_STREAM_TARGET_VOD,
  });
}

export function mockOfflineChannelWithTargetVOD(): void {
  fetchMock.mock(buildLiveToVODStatusURL(CHANNEL_ID, STREAM_ID), {
    body: OFFLINE_CHANNEL_TARGET_VOD,
  });
}

export function mockOfflineChannelWithoutTargetVOD(): void {
  fetchMock.mock(buildLiveToVODStatusURL(CHANNEL_ID, STREAM_ID), {
    body: OFFLINE_CHANNEL_WITHOUT_TARGET_VOD,
  });
}

export function mockVODExistsButStreamIsForDifferentChannel(): void {
  fetchMock.mock(buildLiveToVODStatusURL(CHANNEL_ID, WRONG_CHANNEL_STREAM_ID), {
    body: VOD_EXISTS_BUT_STREAM_IS_FOR_DIFFERENT_CHANNEL,
  });
}
