import configureMockStore, { MockStore } from 'redux-mock-store';
import thunk from 'redux-thunk';

import { RootStateDeepPartial } from 'mtest/helpers/createTestState';
import { RootState } from 'mweb/common/reducers/root';
import { createTestState } from 'mtest/helpers/createTestState';

export function createTestStore(
  opts: RootStateDeepPartial = {},
): MockStore<RootState> {
  const mockStore = configureMockStore([thunk]);
  return mockStore(createTestState(opts)) as MockStore<RootState>;
}

export default createTestStore;
