import { spy, SinonSpy } from 'sinon';

import { CustomLatencyEvent } from 'mweb/common/latency/latencyReporter';

type CustomLatencySpies = { [K in CustomLatencyEvent]: SinonSpy };
type SpyGrouper = { reset: () => void };
type MockLatencyReporter = CustomLatencySpies & SpyGrouper;

export const mockLatencyReporter: MockLatencyReporter = {
  playerPlay: spy(),
  playerReady: spy(),
  chatConnected: spy(),
  reset: () => {
    Object.entries(mockLatencyReporter).forEach(([k, v]) => {
      if (k !== 'reset') {
        (v as SinonSpy).reset();
      }
    });
  },
};

export function mockReportLatencyEvent(event: CustomLatencyEvent): () => void {
  return mockLatencyReporter[event];
}
