export function mockFetchStart(): void {
  const time = 12345;
  if (!window.performance) {
    (window as any).performance = {};
  }
  if (!window.performance.timing) {
    (window.performance as any).timing = {};
  }
  if (!window.performance.timing.fetchStart) {
    (window.performance.timing as any).fetchStart = time;
  }
}

export function unMockFetchStart(): void {
  try {
    // If delete doesn't work then it really existed and was not mocked.
    const win = window as any;
    delete win.performance.timing.fetchStart;
    delete win.performance.timing;
    delete win.performance;
  } catch (e) {
    // do nothing
  }
}
