import { shallow, ShallowWrapper } from 'enzyme';
import * as React from 'react';

export interface ImageConfig {
  width: number;
  height: number;
  isMax?: boolean;
}

interface ImageProps extends ImageConfig {
  imageTemplateURL: string;
}

export function shallowImageWrapper(
  ImageElement: (props: ImageProps) => React.ReactElement<{}>,
  { width, height, isMax = false }: ImageConfig,
): ShallowWrapper<{}, {}> {
  return shallow(
    <ImageElement
      isMax={isMax}
      imageTemplateURL="{width}/{height}"
      height={height}
      width={width}
    />,
  );
}
