import expect from 'expect';

interface TimeBounds {
  lower: number;
  upper: number;
}

interface TimeBoxedResult<T> {
  result: T;
  bounds: TimeBounds;
}

export function timeBoxFunctionSeconds<T>(func: () => T): TimeBoxedResult<T> {
  const result = timeBoxFunction(func);
  result.bounds.lower = result.bounds.lower / 1000;
  result.bounds.upper = result.bounds.upper / 1000;
  return result;
}

export function timeBoxFunction<T>(func: () => T): TimeBoxedResult<T> {
  const lower = new Date().valueOf();
  const result = func();
  const upper = new Date().valueOf();

  return {
    result,
    bounds: {
      lower,
      upper,
    },
  };
}

export function expectTimeWithinBounds(time: number, bounds: TimeBounds): void {
  expect(time).toBeLessThanOrEqualTo(bounds.upper);
  expect(time).toBeGreaterThanOrEqualTo(bounds.lower);
}
