import expect from 'expect';
import omit from 'lodash-es/omit';

import createTestState from 'mtest/helpers/createTestState';

import {
  getBaseSpadeData,
  getSpadeDataWithTime,
  getSpadeDataWithLocation,
  getSpadeDataWithTimeAndLocation,
  SpadeData,
} from 'mweb/common/selectors/tracking/base';

const baseKeys = Object.keys(getBaseSpadeData(createTestState()));
export function expectEqualWithoutSpadeBase(
  actual: SpadeData,
  expected: Object,
): void {
  expect(actual).toIncludeKeys(baseKeys);
  expect(omit(actual, baseKeys)).toEqual(expected);
}

const baseAndTimeKeys = Object.keys(getSpadeDataWithTime(createTestState()));
export function expectEqualWithoutSpadeBaseAndTime(
  actual: SpadeData,
  expected: Object,
): void {
  expect(actual).toIncludeKeys(baseAndTimeKeys);
  expect(omit(actual, baseAndTimeKeys)).toEqual(expected);
}

const baseAndLocationKeys = Object.keys(
  getSpadeDataWithLocation(createTestState()),
);
export function expectEqualWithoutSpadeBaseAndLocation(
  actual: SpadeData,
  expected: Object,
): void {
  expect(actual).toIncludeKeys(baseAndLocationKeys);
  expect(omit(actual, baseAndLocationKeys)).toEqual(expected);
}

const baseTimeAndLocationKeys = Object.keys(
  getSpadeDataWithTimeAndLocation(createTestState()),
);
export function expectEqualWithoutSpadeBaseTimeAndLocation(
  actual: SpadeData,
  expected: Object,
): void {
  expect(actual).toIncludeKeys(baseTimeAndLocationKeys);
  expect(omit(actual, baseTimeAndLocationKeys.concat('referrer_url'))).toEqual(
    expected,
  );
}
