import expect from 'expect';

import createTestState from 'mtest/helpers/createTestState';
import { CHANNEL_DETAILS } from 'mtest/fetchMocks/channel';

import { Action } from 'mweb/common/actions/root';
import {
  buildClipsReducer,
  ClipDetails,
} from 'mweb/common/reducers/data/clips';
import { CHANNELS_DATA_CHANNEL_LOADED_ACTION_TYPE } from 'mweb/common/actions/data/channels';
import { VideoType } from 'mweb/common/reducers/data/baseVideoDetails';

describe('clipDetails reducer', () => {
  const CLIP_1_DETAILS: ClipDetails = {
    id: 'c1',
    title: 'Clip 1',
    thumbnailURL: '//clip1.img',
    url: '//clip1.tv',
    date: 0,
    viewCount: 1,
    game: 'Game',
    channel: CHANNEL_DETAILS.name,
    length: 0,
    formattedLength: '0:00',
    videoType: VideoType.Clip,
  };

  const CLIP_2_DETAILS: ClipDetails = {
    id: 'c2',
    title: 'Clip 2',
    thumbnailURL: '//clip2.img',
    url: '//clip2.tv',
    date: 0,
    viewCount: 2,
    game: 'Game',
    channel: CHANNEL_DETAILS.name,
    length: 0,
    formattedLength: '0:00',
    videoType: VideoType.Clip,
  };

  it('sets defaults', () => {
    const state = buildClipsReducer()(undefined, { type: 'NOOP' });
    expect(state.clipDetails).toEqual({});
    expect(state.clipsByChannelLoadStatus).toEqual({});
  });

  it('adds clips when they come with a channel load', () => {
    const initialState = createTestState().data.clips;
    const action: Action = {
      type: CHANNELS_DATA_CHANNEL_LOADED_ACTION_TYPE,
      payload: {
        channel: CHANNEL_DETAILS,
        hostedChannel: undefined,
        videos: {},
        clips: {
          [CLIP_1_DETAILS.id]: CLIP_1_DETAILS,
          [CLIP_2_DETAILS.id]: CLIP_2_DETAILS,
        },
      },
    };

    const newState = buildClipsReducer()(initialState, action);
    expect(Object.keys(newState.clipDetails).length).toEqual(2);
    expect(newState.clipDetails.c1).toEqual(CLIP_1_DETAILS);
    expect(newState.clipDetails.c2).toEqual(CLIP_2_DETAILS);
    expect(Object.keys(newState.clipsByChannelLoadStatus).length).toEqual(1);
    expect(
      newState.clipsByChannelLoadStatus[CHANNEL_DETAILS.name],
    ).toBeTruthy();
  });
});
