import expect from 'expect';
import faker from 'faker';

import createTestState from 'mtest/helpers/createTestState';
import { CHANNEL_DETAILS } from 'mtest/fetchMocks/channel';
import { GAME_1 } from 'mtest/fetchMocks/games';

import { Action } from 'mweb/common/actions/root';
import {
  eventDetails,
  EventModel,
  EventType,
} from 'mweb/common/reducers/data/events';
import { EventDataPayload } from 'mweb/common/fetch/events';
import { EVENTS_DATA_EVENT_LOADED_ACTION_TYPE } from 'mweb/common/actions/data/events';

describe('eventsData reducer', () => {
  const EVENT_1_DETAILS: EventModel = {
    type: EventType.SingleEvent,
    id: 'e1',
    startTime: 0,
    endTime: 0,
    title: faker.company.catchPhrase(),
    coverImageTemplateURL: faker.image.imageUrl(),
    description: faker.lorem.paragraph(),
    channel: CHANNEL_DETAILS.name,
    game: GAME_1.name,
  };

  const EVENT_2_DETAILS: EventModel = {
    type: EventType.PremiereEvent,
    id: 'e2',
    startTime: 0,
    endTime: 0,
    title: faker.company.catchPhrase(),
    coverImageTemplateURL: faker.image.imageUrl(),
    description: faker.lorem.paragraph(),
    channel: CHANNEL_DETAILS.name,
  };

  const EVENT_1_PAYLOAD: EventDataPayload = {
    event: EVENT_1_DETAILS,
    channel: CHANNEL_DETAILS,
    game: GAME_1,
    vod: undefined,
  };

  it('sets defaults', () => {
    expect(eventDetails(undefined, { type: 'NOOP' })).toEqual({});
  });

  describe('event loading', () => {
    it('adds event data to an empty list', () => {
      const initialState = createTestState().data.events.eventDetails;
      const action: Action = {
        type: EVENTS_DATA_EVENT_LOADED_ACTION_TYPE,
        payload: EVENT_1_PAYLOAD,
      };

      const newState = eventDetails(initialState, action);
      expect(Object.keys(newState).length).toEqual(1);
      expect(newState[EVENT_1_DETAILS.id]).toEqual(EVENT_1_DETAILS);
    });

    it('adds event data to an existing list', () => {
      const initialState = createTestState({
        data: {
          events: {
            eventDetails: {
              e2: EVENT_2_DETAILS,
            },
          },
        },
      }).data.events.eventDetails;
      const action: Action = {
        type: EVENTS_DATA_EVENT_LOADED_ACTION_TYPE,
        payload: EVENT_1_PAYLOAD,
      };

      const newState = eventDetails(initialState, action);
      expect(Object.keys(newState).length).toEqual(2);
      expect(newState[EVENT_1_DETAILS.id]).toEqual(EVENT_1_DETAILS);
      expect(newState[EVENT_2_DETAILS.id]).toEqual(EVENT_2_DETAILS);
    });
  });
});
