import expect from 'expect';

import { Action } from 'mweb/common/actions/root';
import { OS, Browser, device } from 'mweb/common/reducers/device';
import {
  NetInfo,
  PLATFORM_SWITCHED_TO_CLIENT_ACTION_TYPE,
} from 'mweb/common/actions/platform';

describe('device reducer', () => {
  it('sets reasonable defaults', () => {
    expect(device(undefined, { type: 'NOOP' })).toEqual({
      deviceID: '',
      sessionID: '',
      os: OS.Unknown,
      browser: Browser.Unknown,
      netInfo: {},
    });
  });

  it('properly updates in response to PLATFORM_SWITCHED_TO_CLIENT_ACTION_TYPE', () => {
    const action: Action = {
      type: PLATFORM_SWITCHED_TO_CLIENT_ACTION_TYPE,
      payload: {
        os: OS.Android,
        browser: Browser.Chrome,
        netInfo: {} as NetInfo,
      },
    };
    const newState = device(undefined, action);
    expect(newState.os).toEqual(OS.Android);
    expect(newState.browser).toEqual(Browser.Chrome);
  });
});
