import expect from 'expect';

import {
  EXPERIMENTS_CONFIGURED_ACTION_TYPE,
  EXPERIMENTS_RECORD_DECISION_ACTION_TYPE,
  ExperimentsAction,
  ExperimentUUIDs,
  ExperimentNames,
  ExperimentGroups,
} from 'mweb/common/actions/experiments';
import { buildExperimentsReducer } from 'mweb/common/reducers/experiments';

describe('experiments reducer', () => {
  it('sets reasonable defaults', () => {
    expect(buildExperimentsReducer()(undefined, { type: 'NOOP' })).toEqual({
      activeExperiments: {},
      recordedDecisions: {},
    });
  });

  it('sets experiment data on configured', () => {
    const action: ExperimentsAction = {
      type: EXPERIMENTS_CONFIGURED_ACTION_TYPE,
      payload: {
        uuid: ExperimentUUIDs.Test,
        name: ExperimentNames.Test,
        group: ExperimentGroups.Control,
      },
    };
    expect(
      buildExperimentsReducer()(undefined, action).activeExperiments,
    ).toEqual({
      [ExperimentNames.Test]: {
        uuid: ExperimentUUIDs.Test,
        name: ExperimentNames.Test,
        group: ExperimentGroups.Control,
      },
    });
  });

  it('records experiment decisions', () => {
    const action: ExperimentsAction = {
      type: EXPERIMENTS_RECORD_DECISION_ACTION_TYPE,
      payload: {
        uuid: ExperimentUUIDs.Test,
        name: ExperimentNames.Test,
        group: ExperimentGroups.Control,
      },
    };
    expect(
      buildExperimentsReducer()(undefined, action).recordedDecisions,
    ).toEqual({
      [ExperimentNames.Test]: ExperimentGroups.Control,
    });
  });
});
