import expect from 'expect';

import createTestState from 'mtest/helpers/createTestState';

import { Action } from 'mweb/common/actions/root';
import { channelDirectoryPage } from 'mweb/common/reducers/pages/channelDirectory';
import { CHANNEL_DIRECTORY_PAGE_GAME_ALIAS_UPDATED_ACTION_TYPE } from 'mweb/common/actions/pages/channelDirectory';

describe('channelDirectoryPage reducer', () => {
  it('sets defaults', () => {
    expect(channelDirectoryPage(undefined, { type: 'NOOP' })).toEqual({
      currentGameAlias: undefined,
    });
  });

  it('updates current game', () => {
    const initialState = createTestState().pages.channelDirectory;
    const action: Action = {
      type: CHANNEL_DIRECTORY_PAGE_GAME_ALIAS_UPDATED_ACTION_TYPE,
      payload: {
        gameAlias: 'Some Game',
      },
    };

    expect(channelDirectoryPage(initialState, action).currentGameAlias).toEqual(
      'Some Game',
    );
  });
});
