import { NAVIGATION_UPDATED_LOCATION_ACTION_TYPE } from 'mweb/common/actions/navigation';
import expect from 'expect';

import createTestState from 'mtest/helpers/createTestState';

import { Location } from 'mweb/common/reducers/app';
import { channelProfilePage } from 'mweb/common/reducers/pages/channelProfile';
import {
  CHANNEL_PROFILE_PAGE_REDIRECTED_AS_OFFLINE,
  channelProfilePageUpdateChannel,
} from 'mweb/common/actions/pages/channelProfile';

describe('channelProfilePage reducer', () => {
  it('sets defaults', () => {
    expect(channelProfilePage(undefined, { type: 'NOOP' })).toEqual({
      currentChannel: '',
      redirectedAsOffline: false,
    });
  });

  it('updates the current channel', () => {
    const newChannel = 'merrywhether';
    const initialState = createTestState({
      pages: {
        channelProfile: {
          currentChannel: 'monstercat',
        },
      },
    }).pages.channelProfile;
    const action = channelProfilePageUpdateChannel(newChannel);
    expect(channelProfilePage(initialState, action).currentChannel).toEqual(
      newChannel,
    );
  });

  it('sets the redirectedAsOffline flag when CHANNEL_PROFILE_PAGE_REDIRECTED_AS_OFFLINE', () => {
    const state = createTestState({
      pages: {
        channelProfile: {
          redirectedAsOffline: false,
        },
      },
    });
    expect(
      channelProfilePage(state.pages.channelProfile, {
        type: CHANNEL_PROFILE_PAGE_REDIRECTED_AS_OFFLINE,
        payload: {},
      }).redirectedAsOffline,
    ).toEqual(true);
  });

  it('is does nothing to the redirectedAsOffline flag when navigating to the profile page', () => {
    const state = createTestState({
      pages: {
        channelProfile: {
          redirectedAsOffline: true,
        },
      },
    });
    expect(
      channelProfilePage(state.pages.channelProfile, {
        type: NAVIGATION_UPDATED_LOCATION_ACTION_TYPE,
        payload: {
          location: Location.ChannelProfile,
          intent: 'other',
          referrer: 'http://www.twitch.tv/',
        },
      }).redirectedAsOffline,
    ).toEqual(true);
  });
});
