import expect from 'expect';

import createTestState from 'mtest/helpers/createTestState';

import { Action } from 'mweb/common/actions/root';
import { chatEmbedPage } from 'mweb/common/reducers/pages/chatEmbed';
import { CHAT_EMBED_PAGE_CHANNEL_UPDATED_ACTION_TYPE } from 'mweb/common/actions/pages/chatEmbed';

describe('chatEmbedPage reducer', () => {
  it('sets defaults', () => {
    expect(chatEmbedPage(undefined, { type: 'NOOP' })).toEqual({
      currentChannel: '',
    });
  });

  it('updates current channel and resets hosting but not showChat', () => {
    const initialState = createTestState({
      pages: {
        chatEmbed: {
          currentChannel: 'voxel',
        },
      },
    }).pages.chatEmbed;
    const action: Action = {
      type: CHAT_EMBED_PAGE_CHANNEL_UPDATED_ACTION_TYPE,
      payload: {
        channel: 'forks',
      },
    };

    const newState = chatEmbedPage(initialState, action);
    expect(newState.currentChannel).toEqual('forks');
  });
});
