import expect from 'expect';

import createTestState from 'mtest/helpers/createTestState';

import { Action } from 'mweb/common/actions/root';
import { eventDetailsPage } from 'mweb/common/reducers/pages/eventDetails';
import { EVENT_DETAILS_PAGE_EVENT_UPDATED_ACTION_TYPE } from 'mweb/common/actions/pages/eventDetails';

describe('eventDetailsPage reducer', () => {
  it('sets defaults', () => {
    expect(eventDetailsPage(undefined, { type: 'NOOP' })).toEqual({
      currentEventID: '',
    });
  });

  it('updates current event', () => {
    const initialState = createTestState({
      pages: {
        eventDetails: {
          currentEventID: '12',
        },
      },
    }).pages.eventDetails;
    const action: Action = {
      type: EVENT_DETAILS_PAGE_EVENT_UPDATED_ACTION_TYPE,
      payload: {
        eventID: '23',
      },
    };

    const newState = eventDetailsPage(initialState, action);
    expect(newState.currentEventID).toEqual('23');
  });
});
