import expect from 'expect';

import createTestState from 'mtest/helpers/createTestState';

import { Action } from 'mweb/common/actions/root';
import { vodViewerPage } from 'mweb/common/reducers/pages/vodViewer';
import { VOD_VIEWER_PAGE_VOD_UPDATED_ACTION_TYPE } from 'mweb/common/actions/pages/vodViewer';

describe('vodViewerPage reducer', () => {
  it('sets defaults', () => {
    expect(vodViewerPage(undefined, { type: 'NOOP' })).toEqual({
      currentVODid: '',
    });
  });

  it('updates current vod', () => {
    const initialState = createTestState({
      pages: {
        vodViewer: {
          currentVODid: '12345',
        },
      },
    }).pages.vodViewer;

    const action: Action = {
      type: VOD_VIEWER_PAGE_VOD_UPDATED_ACTION_TYPE,
      payload: {
        vodID: '67890',
      },
    };

    const newState = vodViewerPage(initialState, action);
    expect(newState.currentVODid).toEqual('67890');
  });
});
