import expect from 'expect';

import {
  getActiveExperimentData,
  isExperimentDecisionRecorded,
} from 'mweb/common/selectors/experiments';
import createTestState from 'mtest/helpers/createTestState';
import {
  ExperimentUUIDs,
  ExperimentNames,
  ExperimentGroups,
} from 'mweb/common/actions/experiments';

describe('getActiveExperimentData', () => {
  it('returns active experiment data from store', () => {
    const state = createTestState({
      experiments: {
        activeExperiments: {
          [ExperimentNames.Test]: {
            uuid: ExperimentUUIDs.Test,
            name: ExperimentNames.Test,
            group: ExperimentGroups.Treatment,
          },
        },
      },
    });

    const data = getActiveExperimentData(state, ExperimentNames.Test);
    expect(data!.uuid).toEqual(ExperimentUUIDs.Test);
    expect(data!.name).toEqual(ExperimentNames.Test);
    expect(data!.group).toEqual(ExperimentGroups.Treatment);
  });

  it('returns control with no uuid by default', () => {
    const state = createTestState({
      experiments: {
        [ExperimentNames.Test]: {
          uuid: ExperimentUUIDs.Test,
          name: ExperimentNames.Test,
          group: ExperimentGroups.Treatment,
        },
      },
    });

    const data = getActiveExperimentData(state, ExperimentNames.Test);
    expect(data!.uuid).toEqual(undefined);
    expect(data!.name).toEqual(ExperimentNames.Test);
    expect(data!.group).toEqual(ExperimentGroups.Control);
  });

  describe('isExperimentDecisionRecorded', () => {
    it('returns true if recorded', () => {
      const state = createTestState({
        experiments: {
          recordedDecisions: {
            [ExperimentNames.Test]: ExperimentGroups.Control,
          },
        },
      });

      expect(
        isExperimentDecisionRecorded(state, ExperimentNames.Test),
      ).toBeTruthy();
    });

    it('returns false if not recorded', () => {
      const state = createTestState({
        experiments: {
          recordedDecisions: {
            ['some_garbage']: ExperimentGroups.Treatment,
          },
        },
      });

      expect(
        isExperimentDecisionRecorded(state, ExperimentNames.Test),
      ).toBeFalsy();
    });
  });
});
