import { expectEqualWithoutSpadeBaseTimeAndLocation } from 'mtest/helpers/trackingSelectors';
import createTestState from 'mtest/helpers/createTestState';

import {
  getGamesPageLoadedSpadeData,
  getChannelsPageLoadedSpadeData,
} from 'mweb/common/selectors/tracking/dataLoad';
import { GamesDataPageLoadedEventPayload } from 'mweb/common/actions/data/games';
import { ChannelsDataPageLoadedEventPayload } from 'mweb/common/actions/data/channels';

describe('dataLoad selectors', () => {
  it('getGamesPageLoadedSpadeData generates a game directory data page load data structure', () => {
    const state = createTestState({
      tracking: {
        pageLoadID: 'abc',
      },
    });
    const payload: GamesDataPageLoadedEventPayload = {
      gamesLoaded: 30,
    };

    expectEqualWithoutSpadeBaseTimeAndLocation(
      getGamesPageLoadedSpadeData(state, payload),
      {
        game: '',
        cards_received: payload.gamesLoaded,
        page_load_id: state.tracking.pageLoadID,
      },
    );
  });

  it('getChannelsPageLoadedSpadeData generates a channel directory data page load data structure', () => {
    const state = createTestState({
      tracking: {
        pageLoadID: 'abc',
      },
    });
    const payload: ChannelsDataPageLoadedEventPayload = {
      channelsLoaded: 25,
      game: 'Snake Pass',
    };

    expectEqualWithoutSpadeBaseTimeAndLocation(
      getChannelsPageLoadedSpadeData(state, payload),
      {
        game: payload.game,
        cards_received: payload.channelsLoaded,
        page_load_id: state.tracking.pageLoadID,
      },
    );
  });
});
