import { expectEqualWithoutSpadeBaseTimeAndLocation } from 'mtest/helpers/trackingSelectors';
import createTestState from 'mtest/helpers/createTestState';

import { getExperimentBranchSpadeData } from 'mweb/common/selectors/tracking/experiments';
import {
  ExperimentData,
  ExperimentUUIDs,
  ExperimentNames,
  ExperimentGroups,
} from 'mweb/common/actions/experiments';

describe('getExperimentBranchSpadeData', () => {
  it('generates an experiment branch data structure', () => {
    const state = createTestState();
    const experimentData: ExperimentData = {
      uuid: ExperimentUUIDs.Test,
      name: ExperimentNames.Test,
      group: ExperimentGroups.Control,
    };

    expectEqualWithoutSpadeBaseTimeAndLocation(
      getExperimentBranchSpadeData(state, experimentData),
      {
        experiment_id: experimentData.uuid,
        experiment_name: experimentData.name,
        experiment_group: experimentData.group,
      },
    );
  });
});
