import { expectEqualWithoutSpadeBaseTimeAndLocation } from 'mtest/helpers/trackingSelectors';
import createTestState from 'mtest/helpers/createTestState';

import { getClickTrackedSpadeData } from 'mweb/common/selectors/tracking/interaction';
import { UITrackingPayload } from 'mweb/common/actions/tracking';

describe('getClickTrackedSpadeData', () => {
  it('generates a click tracked data structure', () => {
    const state = createTestState();
    const payload: UITrackingPayload = {
      interactionMedium: 'large',
      interactionContent: 'totally',
    };

    expectEqualWithoutSpadeBaseTimeAndLocation(
      getClickTrackedSpadeData(state, payload),
      {
        interaction_content: 'totally',
        interaction_medium: 'large',
        interaction_target_path: undefined,
        interaction: 'click',
      },
    );
  });

  it('generates a click-tracked-with-targetPath data structure', () => {
    const state = createTestState();
    const payload: UITrackingPayload = {
      interactionMedium: 'large',
      interactionContent: 'totally',
      interactionTargetPath: '/path',
    };

    expectEqualWithoutSpadeBaseTimeAndLocation(
      getClickTrackedSpadeData(state, payload),
      {
        interaction_content: 'totally',
        interaction_medium: 'large',
        interaction_target_path: '/path',
        interaction: 'click',
      },
    );
  });
});
