import expect from 'expect';

import {
  expectEqualWithoutSpadeBase,
  expectEqualWithoutSpadeBaseAndTime,
} from 'mtest/helpers/trackingSelectors';
import createTestState from 'mtest/helpers/createTestState';
import {
  timeBoxFunctionSeconds,
  expectTimeWithinBounds,
} from 'mtest/helpers/timeBox';

import {
  getBaseSpadeData,
  getSpadeDataWithTime,
  getSpadeDataWithLocation,
  getSpadeDataWithTimeAndLocation,
} from 'mweb/common/selectors/tracking/base';
import { Location } from 'mweb/common/reducers/app';

describe('root spade data generators', () => {
  it('getBaseSpadeData generates proper payload', () => {
    const state = createTestState({
      tracking: {
        medium: 'medium',
        content: 'content',
      },
      intl: {
        locale: 'en-US',
      },
      app: {
        gitHash: 'deadbeef',
      },
    });
    expect(getBaseSpadeData(state)).toEqual({
      medium: 'medium',
      content: 'content',
      platform: 'mobile_web',
      language: 'en-US',
      gitHash: 'deadbeef',
    });
  });

  it('getSpadeDataWithTime properly captures time value', () => {
    const state = createTestState();
    const { result, bounds } = timeBoxFunctionSeconds(
      getSpadeDataWithTime.bind(undefined, state),
    );
    const time = result.time.valueOf();
    expectTimeWithinBounds(time, bounds);
  });

  it('getSpadeDataWithLocation generates proper payload', () => {
    const state = createTestState({
      app: {
        location: Location.Channel,
      },
    });
    expectEqualWithoutSpadeBase(getSpadeDataWithLocation(state), {
      location: Location.Channel,
    });
  });

  it('getSpadeDataWithTimeAndLocation generates proper payload', () => {
    const state = createTestState({
      app: {
        location: Location.Channel,
      },
    });
    expectEqualWithoutSpadeBaseAndTime(getSpadeDataWithTimeAndLocation(state), {
      location: Location.Channel,
    });
  });
});
