import expect from 'expect';

import {
  redirectForLiveToVOD,
  STREAM_ID_QUERY_PARAMETER,
} from 'mweb/lambda/redirectForLiveToVOD';
import {
  CHANNEL,
  CHANNEL_ID,
  mockOfflineChannelWithTargetVOD,
  mockOnlineChannelWithTargetStream,
  STREAM_ID,
  PARSED_LTV_VOD,
} from 'mtest/fetchMocks/liveToVODStatus';
import fetchMock from 'fetch-mock';
import {
  buildCacheControlHeader,
  PageExpiry,
} from 'mweb/server/selectors/cache';

describe('redirectForLiveToVOD', () => {
  afterEach(() => {
    expect(fetchMock.done()).toEqual(true);
    fetchMock.restore();
  });

  describe('when stream has ended', () => {
    beforeEach(mockOfflineChannelWithTargetVOD);

    it('resolves to a VOD path', () => {
      return redirectForLiveToVOD(CHANNEL_ID, STREAM_ID).then(path => {
        expect(path).toEqual({
          statusCode: 308,
          headers: {
            location: `/videos/${PARSED_LTV_VOD.id.replace('v', '')}`,
            cacheControl: buildCacheControlHeader(PageExpiry.LTV_TO_VOD),
          },
        });
      });
    });
  });
  describe('when stream is still live', () => {
    beforeEach(mockOnlineChannelWithTargetStream);

    it('returns a channel path', () => {
      return redirectForLiveToVOD(CHANNEL_ID, STREAM_ID).then(path => {
        expect(path).toEqual({
          statusCode: 307,
          headers: {
            location: `/${CHANNEL}?${STREAM_ID_QUERY_PARAMETER}=${STREAM_ID}`,
            cacheControl: buildCacheControlHeader(PageExpiry.LTV_TO_LIVE),
          },
        });
      });
    });
  });
});
