import expect from 'expect';
import configureMockStore from 'redux-mock-store';
import { Store } from 'redux';

import { buildSwitchToDesktopSubscriber } from 'mweb/client/subscribers';
import { RootState } from 'mweb/common/reducers/root';

describe('switchToDesktoSubscriber', () => {
  let window: Window, document: Document;

  beforeEach(() => {
    window = {
      location: {
        pathname: '/monstercat',
      },
    } as Window;
    document = {} as Document;
  });

  function buildSubject(optOut: string = ''): () => void {
    let mockStore = configureMockStore();
    let state = {
      app: {
        mobileOptOut: optOut,
      },
    } as RootState;
    let store = mockStore(state);

    return buildSwitchToDesktopSubscriber(
      (store as any) as Store<RootState>,
      window,
      document,
    );
  }

  it('does nothing when not optedOut', () => {
    Object.freeze(window);
    Object.freeze(window.location);
    Object.freeze(document);
    expect(() => buildSubject()()).toNotThrow();
  });

  it('updates the location with the proper href', () => {
    buildSubject('mobile_opt_out')();
    expect(window.location.href).toEqual(
      'https://twitch.tv/monstercat?tt_medium=twitch_mobileweb&tt_content=channel_nav&no-mobile-redirect=true',
    );
  });

  it('sets the mobile_opt_out cookie to true with the proper domain & path', () => {
    buildSubject('mobile_opt_out')();
    expect(document.cookie).toEqual(
      'mobile_opt_out=true; Max-Age=10800; Domain=twitch.tv; Path=/',
    );
  });

  it('sets the upsell_opt_out cookie to true with the proper domain & path', () => {
    buildSubject('upsell_opt_out')();
    expect(document.cookie).toEqual(
      'upsell_opt_out=true; Max-Age=10800; Domain=twitch.tv; Path=/',
    );
  });
});
