import expect from 'expect';
import { Browser, OS } from 'src/common/reducers/device';
import { convertUserAgentToBrowserAndOS } from 'src/common/utils/convertUserAgentToBrowserAndOS';

describe('platformSwitchToClient', () => {
  const tests = [
    { userAgent: 'iPad', os: OS.iOS, browser: Browser.Safari },
    { userAgent: 'iPhone', os: OS.iOS, browser: Browser.Safari },
    { userAgent: 'iPod', os: OS.iOS, browser: Browser.Safari },
    { userAgent: 'iPad; CriOS', os: OS.iOS, browser: Browser.Chrome },
    { userAgent: 'iPhone; CriOS', os: OS.iOS, browser: Browser.Chrome },
    { userAgent: 'iPod; CriOS', os: OS.iOS, browser: Browser.Chrome },
    { userAgent: 'Android', os: OS.Android, browser: Browser.Chrome },
    { userAgent: 'IEMobile', os: OS.Microsoft, browser: Browser.Edge },
    { userAgent: 'Windows Phone', os: OS.Microsoft, browser: Browser.Edge },
    {
      userAgent:
        'Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Silk/44.1.54 like Chrome/44.0.2403.63 Safari/537.36',
      browser: Browser.Silk,
      os: OS.Fire,
    },
    {
      userAgent: 'Windows Phone; Android',
      os: OS.Microsoft,
      browser: Browser.Edge,
    },
    { userAgent: 'XKCD Phone 3', os: OS.Other, browser: Browser.Other },
  ];

  tests.forEach(({ userAgent, os, browser }) => {
    it(`assigns ${browser} on ${os} for ${userAgent} userAgent and captures deviceID and sessionID`, () => {
      const result = convertUserAgentToBrowserAndOS(userAgent);
      expect(result).toEqual({
        os,
        browser,
      });
    });
  });
});
