import expect from 'expect';

import { formatVideoLength } from 'mweb/common/utils/formatVideoLength';

describe('formatVideoLength', () => {
  const testCases = [
    {
      title: 'formats zero',
      length: 0,
      formattedLength: '0:00',
    },
    {
      title: 'adds zero minutes to seconds-long videos',
      length: 41,
      formattedLength: '0:41',
    },
    {
      title: 'zero pads non leading single digit numbers',
      length: 14886,
      formattedLength: '4:08:06',
    },
    {
      title: 'does not strip internal zeros',
      length: 23640,
      formattedLength: '6:34:00',
    },
    {
      title: 'does not zero pad two digit numbers',
      length: 36790,
      formattedLength: '10:13:10',
    },
    {
      title: 'handles days',
      length: 143823,
      formattedLength: '1:15:57:03',
    },
  ];

  testCases.forEach(({ title, length, formattedLength }) => {
    it(title, () => {
      expect(formatVideoLength(length)).toEqual(formattedLength);
    });
  });
});
