import expect from 'expect';
import {
  buildStringFromTemplate,
  getSrcAndSrcSet,
} from 'mweb/common/utils/imageUtils';

describe('buildStringFromTemplate', () => {
  it('replaces width and height', () => {
    const template = 'https://{width}/{height}';
    expect(buildStringFromTemplate(template, 1, 2)).toEqual('https://1/2');
  });
});

describe('getSrcAndSrcSet', () => {
  const template = 'https://{width}/{height}';
  const imageWidths = [100, 200, 300];
  it('returns src and src set properly', () => {
    expect(getSrcAndSrcSet(template, imageWidths, 4 / 3)).toEqual({
      src: 'https://100/133',
      srcSet: {
        '100w': 'https://100/133',
        '200w': 'https://200/267',
        '300w': 'https://300/400',
      },
    });
  });

  it('respects different aspect ratios', () => {
    expect(getSrcAndSrcSet(template, imageWidths, 9 / 16)).toEqual({
      src: 'https://100/56',
      srcSet: {
        '100w': 'https://100/56',
        '200w': 'https://200/113',
        '300w': 'https://300/169',
      },
    });
  });
});
