import expect from 'expect';
import sinon from 'sinon';
import { memoize } from 'mweb/common/utils/memoize';

describe('memoize', () => {
  it('caches the return value of a function call', () => {
    const mock = sinon.spy((a: number, b: number) => a + b);
    const memoized = memoize(mock);
    expect(memoized(1, 2)).toEqual(3);
    expect(memoized(1, 2)).toEqual(3);
    expect(mock.calledOnce).toBe(true);
    expect(memoized(2, 1)).toEqual(3);
    expect(mock.calledTwice).toBe(true);
  });

  it('caches the return value of a function with no arguments', () => {
    const mock = sinon.spy(() => 1);
    const memoized = memoize(mock);
    expect(memoized()).toEqual(1);
    expect(memoized()).toEqual(1);
    expect(mock.calledOnce).toBe(true);
  });
});
