import expect from 'expect';
import {
  buildPathForBaseVideo,
  buildVODPath,
} from 'mweb/common/utils/pathBuilders';
import { VODDetails } from 'mweb/common/reducers/data/vods';
import { ClipDetails } from 'mweb/common/reducers/data/clips';
import { VideoType } from 'mweb/common/reducers/data/baseVideoDetails';

describe('buildVODPath', () => {
  it('builds path given id prefixed with v', () => {
    expect(buildVODPath('v123')).toEqual('/videos/123');
  });

  it('builds path given id not prefixed with v', () => {
    expect(buildVODPath('321')).toEqual('/videos/321');
  });
});

describe('buildPathForBaseVideo', () => {
  it('builds path for archives', () => {
    const archive = {
      id: 'v123',
      videoType: VideoType.Archive,
    } as VODDetails;
    expect(buildPathForBaseVideo(archive)).toEqual(buildVODPath(archive.id));
  });

  it('builder path for highlights', () => {
    const highlight = {
      id: 'v321',
      videoType: VideoType.Highlight,
    } as VODDetails;
    expect(buildPathForBaseVideo(highlight)).toEqual(
      buildVODPath(highlight.id),
    );
  });

  it('builders path for clips', () => {
    const clip = {
      url: 'www.alec-lee.com',
      videoType: VideoType.Clip,
    } as ClipDetails;
    expect(buildPathForBaseVideo(clip)).toEqual(clip.url);
  });
});
