
if (process.env.IS_LOCAL) {
  process.env.AWS_PROFILE = 'cpe-tools'
  process.env.AWS_REGION = 'us-west-2'
  process.env.AWSAccountId = '994136867826'
}

import AWS = require('aws-sdk');
const AWSJS = require('aws-sdk');

AWS.config.update({
  region: process.env.AWS_REGION
});

AWSJS.events.on('retry', function (resp: any) {
  if (resp.error && resp.error.code === 'Throttling') {
    resp.error.retryable = true;
  }
});

AWS.config.update({
  maxRetries: 9,
  // retryDelayOptions: {
  //   base: 100
  // }
});

import { AWSTags } from './src/cache';
AWSTags.init

import processor from './src/processor';
export const handler = processor;
