export interface Datapoint {
  Timestamp?: AWS.CloudWatch.Types.Timestamp;
  SampleCount?: AWS.CloudWatch.Types.DatapointValue;
  Average?: AWS.CloudWatch.Types.DatapointValue;
  Sum?: AWS.CloudWatch.Types.DatapointValue;
  Minimum?: AWS.CloudWatch.Types.DatapointValue;
  Maximum?: AWS.CloudWatch.Types.DatapointValue;
  Unit?: AWS.CloudWatch.Types.StandardUnit;
  ExtendedStatistics?: AWS.CloudWatch.Types.DatapointValueMap;
  p50?: AWS.CloudWatch.Types.DatapointValue;
  p90?: AWS.CloudWatch.Types.DatapointValue;
  p95?: AWS.CloudWatch.Types.DatapointValue;
  p99?: AWS.CloudWatch.Types.DatapointValue;
}

export type Datapoints = Datapoint[];

export interface CloudwatchMetricStructure {
  Definition: {
    Namespace: AWS.CloudWatch.Types.Namespace,
    MetricName: AWS.CloudWatch.Types.MetricName,
    Dimensions: AWS.CloudWatch.Types.Dimensions
  },
  Metric: {
    Label: AWS.CloudWatch.Types.MetricLabel,
    Datapoints: Datapoints
  }
}
