export interface SensuValueSet {
  [name: string]: number
}

export interface SensuTagSet {
  [name: string]: string
}

export interface SensuMetricStructure {
  source: string,
  series: string,
  tags: SensuTagSet,
  timestamp: Date,
  unit: string,
  values: SensuValueSet
}

export interface SensuResult {
  client: string,
  check: {
    type: string,
    status: number,
    ttl: number,
    interval: number,
    name: string,
    awsAccountId: string,
    stage: string,
    region: string,
    environment: string,
    issued: number,
    executed: number,
    timestamp: number,
    output: string,
    handlers: string[]
  }
}

export interface Filter {
  (e: any): boolean
}