import AWS = require('aws-sdk');
import { CloudwatchHelpers } from '../aws/cloudwatch';
import { Metric } from './Metric';
import { Filter } from '../interfaces/sensu';

export class Metrics {
  metrics: Metric[] = [];

  constructor() { }

  public async fillMetrics() {
    return CloudwatchHelpers.pullCloudwatchMetrics().then(metrics => {
      this.metrics = metrics;
    })
  }

  public getMetrics(filter: Filter = ((e) => { return true })): Metric[] {
    return this.metrics.filter(filter)
  }

}
