import { Metrics } from './models/Metrics';
import { AWSTags } from './cache';
import { SensuMetricStructure } from './interfaces/sensu';
import { SNSHelpers } from './aws/sns';


export default async function processor(event: any, context: any, callback: any) {
  let metrics = new Metrics();

  try {
    await Promise.all([
      AWSTags.init.fillCaches(),
      metrics.fillMetrics()
    ]);
  } catch (error) {
      callback(error);
  }

  let filteredMetrics: SensuMetricStructure[] = metrics.getMetrics((metric) => {
    if (metric.requiresTagCache() && !metric.hasTagCache()) return false;
    return true;
  }).map((metric) => {
    return metric.toSensuPoint();
  });

  if (process.env.IS_LOCAL) {
    // Debug
    console.log(JSON.stringify(filteredMetrics, null, 2));
    callback(null, "Done!")
  } else {
    try {
      await SNSHelpers.submitToSNS(filteredMetrics);
      callback(null, "Done!")
    } catch (error) {
      callback(error);
    }
  }

}

