export interface FastlyServices {
    [service_id: string]: FastlyServicesResponseService
}

export interface FastlyServicesResponse {
    data: FastlyServicesResponseService[];
}

export interface FastlyServicesResponseService {
    id: string;
    type: string;
    attributes: {
        comment: string;
        name: string;
        customer_id: string;
        created_at: string;
        deleted_at: string;
        updated_at: string;
        active_version: number;
    };
    relationships: {
        customer: {
            data: {
                id: string;
                type: string;
            }
        }
    }
}