export interface FastlyStatsResponse {
    data: {
        [service_id: string]: FastlyStatsResponseMetric[]
    };
    status: string;
    msg: null | string;
    meta: {
        from: string;
        to: string;
        by: string;
        region: string;
    }
}

export interface FastlyStatsResponseMetricDataPoints {
    [name: string]: number;
}

export interface FastlyStatsResponseMetric {
    [name: string]: number | string;
    start_time: number;
    requests: number;
    hits: number;
    miss: number;
    uncacheable: number;
    pass: number;
    pipe: number;
    synth: number;
    blacklist: number;
    tls: number;
    ipv6: number;
    http2: number;
    shield: number;
    log: number;
    pci: number;
    video: number;
    imgopto: number;
    otfp: number;
    otfp_manifests: number;
    restarts: number;
    hits_time: number;
    miss_time: number;
    pass_time: number;
    status_1xx: number;
    status_2xx: number;
    status_3xx: number;
    status_4xx: number;
    status_5xx: number;
    status_200: number;
    status_204: number;
    status_301: number;
    status_302: number;
    status_304: number;
    status_400: number;
    status_401: number;
    status_403: number;
    status_404: number;
    status_416: number;
    status_500: number;
    status_501: number;
    status_502: number;
    status_503: number;
    status_504: number;
    status_505: number;
    req_header_bytes: number;
    req_body_bytes: number;
    resp_header_bytes: number;
    resp_body_bytes: number;
    bereq_header_bytes: number;
    bereq_body_bytes: number;
    shield_resp_header_bytes: number;
    shield_resp_body_bytes: number;
    waf_blocked: number;
    waf_logged: number;
    waf_passed: number;
    attack_req_header_bytes: number;
    attack_req_body_bytes: number;
    attack_resp_synth_bytes: number;
    attack_logged_req_header_bytes: number;
    attack_logged_req_body_bytes: number;
    attack_blocked_req_header_bytes: number;
    attack_blocked_req_body_bytes: number;
    attack_passed_req_header_bytes: number;
    attack_passed_req_body_bytes: number;
    imgopto_resp_header_bytes: number;
    imgopto_resp_body_bytes: number;
    imgopto_shield_resp_header_bytes: number;
    imgopto_shield_resp_body_bytes: number;
    otfp_resp_header_bytes: number;
    otfp_resp_body_bytes: number;
    otfp_shield_resp_header_bytes: number;
    otfp_shield_resp_body_bytes: number;
    otfp_shield_time: number;
    otfp_deliver_time: number;
    tls_v10: number;
    tls_v11: number;
    tls_v12: number;
    tls_v13: number;
    object_size_1k: number;
    object_size_10k: number;
    object_size_100k: number;
    object_size_1m: number;
    object_size_10m: number;
    object_size_100m: number;
    object_size_1g: number;
    header_size: number;
    body_size: number;
    orig_req_header_size: number;
    orig_req_body_size: number;
    orig_resp_header_size: number;
    orig_resp_body_size: number;
    service_id: string;
    errors: number;
    hit_ratio: number;
    bandwidth: number;
  }