import { SensuTagSet, SensuValueSet, SensuMetricStructure } from '../interfaces/sensu';
import { FastlyStatsResponseMetric, FastlyStatsResponseMetricDataPoints } from '../api/fastly/interfaces/stats';
import { FastlyStatDefinition } from '../interfaces/fastly';

export class Metric {
  values: FastlyStatsResponseMetricDataPoints;
  definition: FastlyStatDefinition;

  constructor(metric: FastlyStatsResponseMetric, definition: FastlyStatDefinition) {
    this.values = {};

    for (let datapoint of Object.keys(metric)) {
      if (datapoint === 'service_id' || datapoint === 'start_time') continue;

      if (datapoint.indexOf('_time') > -1) {
        // Convert seconds to ms
        this.values[datapoint] = (metric[datapoint] as number) * 1000;
      } else {
        this.values[datapoint] = metric[datapoint] as number;
      }
    }

    this.definition = definition;
  }

  getTagSet(): SensuTagSet {
    let tagSet: SensuTagSet = {};
    tagSet.service_id = this.definition.service_id;
    tagSet.service_name = this.definition.service_name;
    tagSet.region = this.definition.region;
    return tagSet;
  }

  getValueSet(): SensuValueSet {
    let values: SensuValueSet = {};
    values = this.values;
    return values;
  }

  toSensuPoint(): SensuMetricStructure {
    let data = {
      source: 'fastly',
      series: 'fastly_stats',
      tags: this.getTagSet(),
      timestamp: this.definition.timestamp,
      values: this.getValueSet()
    }
    return data;
  }
}
