import { Metric } from './Metric';
import { Fastly } from '../api/fastly/client';
import { FastlyStatsResponseMetric } from '../api/fastly/interfaces/stats';
import { FastlyStatDefinition } from '../interfaces/fastly';

export class Metrics {
  fastly: Fastly;
  metrics: Metric[] = [];

  constructor(api_key: string) {
    this.fastly = new Fastly(api_key);
  }

  public async fillMetrics() {
    return this.fastly.regional_stats().then(regions => {
      for (let region of regions) {
        for (let service of Object.keys(region.data)) {
          for (let metric of region.data[service]) {

            let definition: FastlyStatDefinition = {
              service_name: this.fastly.services[service].attributes.name,
              service_id: service,
              region: region.meta.region,
              timestamp: new Date(metric.start_time * 1000)
            }

            this.metrics.push(new Metric(metric, definition))

          }
        }
      }
    });
  }

  public getMetrics(): Metric[] {
    return this.metrics
  }

}
