import { InfluxDB, IPoint } from 'influx';

export interface InfluxTags {
  [name: string]: string;
}

export interface InfluxFields {
  [name: string]: number | string | boolean;
}

export interface DataPoints {
  [key: string]: IPoint[];
}

export const InfluxClient = (password: string) => {
  return new InfluxDB({
    host: 'ops-influxdb.cpe.wtf',
    protocol: 'https',
    port: 8486,
    username: 'sensu',
    password:  password,
    database: 'cpe_stats',
    schema: [],
    pool: {
      requestTimeout: 60000
    }
  });
};