import { IPoint } from 'influx'
import { InfluxFields, InfluxTags } from '../influx';
import { DataPoint, DataPointStructure } from './DataPoint';

const nameRegExp = new RegExp('[/.]', 'g');

export class CloudwatchDataPoint extends DataPoint {
  constructor(data: DataPointStructure) {
    super(data);
    this.mutate();
  }

  mutate(): void {
    if (this.raw.unit === "Seconds") {
      for (let k in this.raw.values) {
        if (k !== "SampleCount") {
          this.raw.values[k] *= 1000;
        }
      }
    }
    this.raw.Namespace = this.raw.tags.Namespace;
    delete this.raw.tags.Namespace;
  }

  measurementName(): string {
    return (this.raw.Namespace + '_' + this.raw.series).replace(nameRegExp, '_').toLowerCase();
  }

  getFields(): InfluxFields {
    return this.raw.values;
  }

  getTags(): InfluxTags {
    return this.raw.tags;
  }

}
