import { IPoint } from 'influx'
import { InfluxFields, InfluxTags } from '../influx';

export interface DataPointStructure {
  [name: string]: any;
}

export class DataPoint {
  raw: DataPointStructure;
  timestamp: Date;

  constructor(data: DataPointStructure) {
    this.raw = data;
    this.timestamp = new Date(data.timestamp);
  }

  toInflux(): IPoint {
    const data = {
      measurement: this.measurementName(),
      timestamp: this.timestamp,
      tags: this.getTags(),
      fields: this.getFields()
    }

    return data;
  }

  measurementName(): string {
    throw Error('unimplemented method');
  }

  getFields(): InfluxFields {
    throw Error('unimplemented method');
  }

  getTags(): InfluxTags {
    throw Error('unimplemented method');
  }

}
