import { IPoint } from 'influx'
import { InfluxFields, InfluxTags } from '../influx';
import { DataPoint, DataPointStructure } from './DataPoint';

export class FastlyDataPoint extends DataPoint {
  constructor(data: DataPointStructure) {
    super(data);
  }

  measurementName(): string {
    return (this.raw.series).toLowerCase();
  }

  getFields(): InfluxFields {
    return this.raw.values;
  }

  getTags(): InfluxTags {
    return this.raw.tags;
  }

}
