import { IPoint } from 'influx'
import { InfluxFields, InfluxTags } from '../influx';
import { DataPoint, DataPointStructure } from './DataPoint';

export class TherapistDataPoint extends DataPoint {
  constructor(data: DataPointStructure) {
    super(data);
  }

  measurementName(): string {
    return ('therapist_' + this.raw.metricName);
  }

  getFields(): InfluxFields {
    return this.raw.values;
  }

  getTags(): InfluxTags {
    return this.raw.tags;
  }

}
