/*
 * Copyright 2000-2012 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jetbrains.buildServer.commitPublisher.github.api.impl;

import jetbrains.buildServer.commitPublisher.github.api.GitHubApi;
import jetbrains.buildServer.commitPublisher.github.api.GitHubApiFactory;
import org.apache.http.HttpRequest;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.impl.auth.BasicScheme;
import org.jetbrains.annotations.NotNull;

/**
 * Created by Eugene Petrenko (eugene.petrenko@gmail.com)
 * Date: 06.09.12 2:54
 */
public class GitHubApiFactoryImpl implements GitHubApiFactory {
  private final HttpClientWrapper myWrapper;

  public GitHubApiFactoryImpl(@NotNull final HttpClientWrapper wrapper) {
    myWrapper = wrapper;
  }


  @NotNull
  public GitHubApi openGitHubForUser(@NotNull final String url,
                                     @NotNull final String username,
                                     @NotNull final String password) {
    return new GitHubApiImpl(myWrapper, new GitHubApiPaths(url)){
      @Override
      protected void setAuthentication(@NotNull HttpRequest request) throws AuthenticationException {
        request.addHeader(new BasicScheme().authenticate(new UsernamePasswordCredentials(username, password), request));
      }
    };
  }

  @NotNull
  public GitHubApi openGitHubForToken(@NotNull final String url,
                                      @NotNull final String token) {
    return new GitHubApiImpl(myWrapper, new GitHubApiPaths(url)){
      @Override
      protected void setAuthentication(@NotNull HttpRequest request) throws AuthenticationException {
        //NOTE: This auth could also be done via HTTP header
        request.addHeader(new BasicScheme().authenticate(new UsernamePasswordCredentials(token, "x-oauth-basic"), request));
      }
    };
  }
}
