base_dir = File.join(File.dirname(File.expand_path(__FILE__)), '..')

require 'etc'

log_level                :info
log_location             STDOUT
node_name                Etc.getlogin # If you don't match your chef username with your machine username this is a problem we don't have a full fix for... we eagerly await your PR.
client_key               File.join(base_dir, '.chef', 'private.pem')
syntax_check_cache_path  File.join(base_dir, '.chef', 'syntax_check_cache')
cookbook_path            [File.join(base_dir, 'cookbooks')]

chef_server_url          'https://cpe-chef-heqtcjndac2ptfp4.us-west-2.opsworks-cm.io/organizations/default'
ssl_ca_file              File.join(base_dir, '.chef', 'ca_certs', 'opsworks-cm-ca-2016-root.pem')
trusted_certs_dir        File.join(base_dir, '.chef', 'ca_certs')

# local_mode true
