#!/usr/bin/env ruby

class NilClass; def empty?; true; end; end

git_submodule = `git submodule foreach --recursive "git --no-pager show -1 -s --pretty=%D HEAD"`
puts git_submodule
abort 'Project does not have any submodules' if git_submodule.empty?

submodules = git_submodule.split("\n")
submodule = nil
non_release_submodules = []
submodules.each do |sm|
  if /^Entering '(.+)'$/ =~ sm
    submodule = sm.match(/^Entering '(.+)'$/)[1]
    next
  end

  # TODO: remove this special case after desktop, installer, and nativecomponents are master merged
  next if ['desktop', 'installer', 'nativecomponents', 'Curse.ServiceClients'].include?(submodule) && sm.include?('origin/shared/desklight-root')

  non_release_submodules << submodule unless sm.match(/tag: v[0-9]+\.[0-9]+\.[0-9]+/) || sm.include?('origin/master')
end

abort "The following projects contain non-release submodules: #{non_release_submodules.inspect}" unless non_release_submodules.empty?

puts 'All project submodules verified'
