# DNS migration automation for Infoblox via dnsapi

Script to automate migration of DNS records in Infoblox and point them at Fastly IPs

### Required env vars
- TWITCH_OAUTH_TOKEN - must be populated with a session token from https://dnsapi.internal.justin.tv/login/oauth2/authorization, which uses Twitch SSO
- OVERRIDE_SELF_DESTRUCT_SEQUENCE - flag to prevent accidentally triggering the change

### Process
Note: Must be on the Twitch network to follow these steps
1. Select a dummy domain to use (ex. asdf1234567.twitch.tv) and set up records for that domain at https://dashboard.internal.justin.tv/dns
1. Monitor for DNS changes:
  * In a shell (A), run `while true; do dig <dummy domain>; sleep 5; done`
  * In another shell (B), run `while true; do dig <domain you want to migrate>; sleep 5; done`
  * In yet another shell (C), run `while true; do dig @8.8.8.8 <domain you want to migrate>; sleep 5; done` (monitors for propagation on Google DNS)
2. In code, modify value for DO_NOT_MESS_UP_THIS_DOMAIN to <dummy domain>
3. Run the script against the dummy domain (see example below)
4. In code, modify value for DO_NOT_MESS_UP_THIS_DOMAIN to <domain you want to migrate>
5. When you see the DNS change propagate for the dummy domain, immediately run the script against the domain you want to migrate (see example below)
  * Timing the production deploy against the internal (Twitch network) DNS change limits the chances of having bad DNS (or no DNS) propagate to the world.

Other options for verifying propagation:
* https://www.whatsmydns.net
* https://dnschecker.org

### Example
```shell
export TWITCH_OAUTH_TOKEN=123412341234
export OVERRIDE_SELF_DESTRUCT_SEQUENCE=script-specific-override
ruby SCRIPT.rb
```

### Resources
DNS API docs: https://git-aws.internal.justin.tv/systems/self-service-dns/blob/master/API.md
