#!/usr/bin/env sh

# Install SonarQube Scanner
dotnet tool install --global dotnet-sonarscanner

# Add Global dotnet tools to PATH
export PATH="$PATH:$HOME/.dotnet/tools"

# Create results folder
mkdir /opt/results

# Run Code Quality
dotnet sonarscanner begin "/d:sonar.login=$SONAR_TOKEN" '/d:sonar.host.url=https://api.codeanalysis.security.xarth.tv' "/k:$IMAGE_NAME" "/v:$BUILD_NUMBER" '/d:sonar.cs.opencover.reportsPaths="/opt/results/coverage.opencover.xml"' '/d:sonar.cs.vstest.reportsPaths="/opt/results/testresults.xml"'
dotnet build -c 'Debug' -o 'dist' '/flp:NoSummary;Verbosity=q;LogFile=/opt/results/scan.log' '/property:TreatWarningsAsErrors=False'
dotnet test --logger:"console;verbosity=normal" --logger:"trx;LogFileName=/opt/results/testresults.xml" /p:CollectCoverage=true /p:Include=\"[Twitch.*]*\" /p:Exclude=\"[Twitch.*.Tests?]*\" /p:CoverletOutputFormat=\"cobertura,teamcity,opencover\" /p:CoverletOutput=/opt/results/
dotnet sonarscanner end "/d:sonar.login=$SONAR_TOKEN"

# Report Test Coveragee
curl -s https://codecov.xarth.tv/bash > codecov
chmod +x codecov
./codecov -f "/opt/results/coverage.cobertura.xml" -t ghe -y codecov.yml -n $BUILD_NUMBER