# frozen_string_literal: true

GIB_DATA_PATH = ENV.fetch('GIB_DATA_PATH') { './data' }.freeze
GIB_USERNAME = ENV.fetch('GIB_USERNAME').freeze
GIB_PASSWORD = ENV.fetch('GIB_PASSWORD').freeze

$LOAD_PATH.unshift(File.expand_path(File.join(File.dirname(__FILE__), 'lib')))
require 'geminabox'

Geminabox.data = GIB_DATA_PATH
Geminabox.rubygems_proxy = true
Geminabox.allow_remote_failure = true

Geminabox::Server.helpers do
  def protected!
    unless authorized?
      response['WWW-Authenticate'] = %(Basic realm="Geminabox")
      halt 401, 'No pushing or deleting without auth.'
    end
  end

  def authorized?
    @auth ||=  Rack::Auth::Basic::Request.new(request.env)
    @auth.provided? && @auth.basic? && @auth.credentials && @auth.credentials == [GIB_USERNAME, GIB_PASSWORD]
  end
end

Geminabox::Server.before '/upload' do
  protected!
end

Geminabox::Server.before do
  protected! if request.delete?
end

Geminabox::Server.before '/api/v1/gems' do
  halt 401, 'Access Denied. Credentials invalid or missing.' unless authorized?
end

run Geminabox::Server
