# frozen_string_literal: true

require 'uri'

class String
  def indent(depth = 1, size = 2)
    split("\n", -1).collect { |line| (' ' * size * depth) + line }.join("\n")
  end

  def max_of(length)
    self.length > length ? "#{self[0..(length-3)]}..." : self
  end

  def uri_escape
    URI.escape(self)
  end
end

class Numeric
  def pretty
    to_s.reverse.gsub(/(\d{3})(?=\d)/, '\\1,').reverse
  end
end
