# frozen_string_literal: true

require 'rom'
require 'rom-sql'

require_relative 'persistence/repositories/run_repo'
require_relative 'persistence/repositories/test_repo'

module Indicina
  class << self
    # noinspection RubyResolve
    attr_reader :runs, :tests
  end

  rom_container = ROM.container(:sql, Indicina::DB_PATH) do |config|
    config.auto_registration(Indicina::PERSISTENCE_PATH, namespace: false)
  end

  # rom_container.gateways[:default].use_logger(Logger.new($stdout))

  @runs = RunRepo.new(rom_container)
  @tests = TestRepo.new(rom_container)
end
